/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockListener;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;

class DeviceLock {
    private static final String TRACE_MASKT = "XMDALOCT";
    private static final String TRACE_MASKF = "XMDALOCF";
    private static final String TRACE_MASKD = "XMDALOCD";
    private boolean locked;
    private ArrayList listeners;
    private MediaDeviceLockListener listener;
    private int stateChange;

    DeviceLock() {
        Trace.trace(TRACE_MASKT, "-> DeviceLock.DeviceLock()");
        this.locked = false;
        this.listeners = new ArrayList();
        Trace.trace(TRACE_MASKT, "<- DeviceLock.DeviceLock()");
    }

    void setLock(boolean lock) {
        Trace.trace(TRACE_MASKT, "-> DeviceLock.setLock(" + lock + ")");
        this.locked = lock;
        this.notifyListeners(lock ? 1 : 2);
        Trace.trace(TRACE_MASKT, "<- DeviceLock.setLock()");
    }

    boolean getLock() {
        Trace.trace(TRACE_MASKT, "<> DeviceLock.getLock(): returns " + this.locked);
        return this.locked;
    }

    void addDeviceLockListener(MediaDeviceLockListener listener) {
        Trace.trace(TRACE_MASKT, "-> DeviceLock.addDeviceLockListener(MediaDeviceLockListener = " + listener + ")");
        this.listeners.add(listener);
        Trace.trace(TRACE_MASKT, "<- DeviceLock.addDeviceLockListener()");
    }

    void removeDeviceLockListener(MediaDeviceLockListener listener) {
        Trace.trace(TRACE_MASKT, "-> DeviceLock.removeDeviceLockListener(MediaDeviceLockListener = " + listener + ")");
        try {
            this.listeners.remove(listener);
        }
        catch (IndexOutOfBoundsException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- DeviceLock.removeDeviceLockListener()");
    }

    synchronized void notifyListeners(int change) {
        Trace.trace(TRACE_MASKT, "-> DeviceLock.notifyListeners(" + change + ")");
        ArrayList listenersClone = (ArrayList)this.listeners.clone();
        this.stateChange = change;
        for (int i = 0; i < listenersClone.size(); ++i) {
            try {
                this.listener = (MediaDeviceLockListener)listenersClone.get(i);
                Thread thread = new Thread(){

                    public void run() {
                        DeviceLock.this.listener.lockChange(DeviceLock.this.stateChange);
                    }
                };
                thread.setName("Media Services Device Lock Listeners Thread");
                thread.start();
                continue;
            }
            catch (IndexOutOfBoundsException exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
        }
        Trace.trace(TRACE_MASKT, "<- DeviceLock.notifyListeners()");
    }
}

